function writeToFile(fileName,A,rowLabels,columnLabels)
%WRITETOFILE Write a matrix A and its row and column labels to a CSV text
%   file

fid = fopen(fileName,'w');
fprintf(fid,',');
fprintf(fid,'%s,',columnLabels{:});
fprintf(fid,'\r\n');
format short
for i = 1:numel(rowLabels)
    fprintf(fid,'%s,',rowLabels{i});
    for j = 1:numel(columnLabels)
        if A(i,j) == 0
            fprintf(fid,',');
        else            
            fprintf(fid,'%f,',A(i,j));
        end
    end
    fprintf(fid,'\r\n');
end
fclose(fid);

end

